# number of timesteps to iterate the model
t_max = 50
# initial (rescaled) population size
x0 = 0.01
# (rescaled) intrinsic population growth rate
a = 3.1

# initialise vector to store the population sizes over time
xs = numeric(t_max+1)
xs[1] = x0

# execute a loop iterating the map
for ( t in 1:t_max )
  xs[t+1] = a*xs[t]*(1-xs[t])

# plot the results
plot(0:t_max,xs,pch=19,type='o',xlab='t',ylab='x',
     ylim=c(0,1)) 
